# Image Compression Plugin

Automatically compress and optimize images using TinyPNG API with before/after comparisons, bulk compression, and scheduled compression with folder exclusion support.

## 🚀 Features

### Core Compression Features
- **Automatic Image Compression**: Compress images on upload using TinyPNG API
- **Bulk Compression**: Process multiple images at once with progress tracking
- **Manual Compression**: Compress individual images from media library
- **Before/After Comparisons**: See original vs compressed file sizes and savings
- **Compression Statistics**: Track total savings and compression history

### Advanced Scheduling
- **Scheduled Compression**: Automatically compress uncompressed images on a schedule
- **Flexible Intervals**: Choose from every minute to weekly schedules
- **Batch Processing**: Set custom batch sizes or unlimited processing
- **Activity Logging**: Track all compression activities with detailed logs

### NEW: Folder Exclusion (FileBird Integration)
- **Smart Folder Detection**: Automatically detects FileBird plugin
- **Selective Exclusion**: Exclude specific folders from scheduled compression
- **Hierarchical Support**: Excluding parent folders automatically excludes subfolders
- **Preserve Originals**: Keep certain folders with uncompressed images
- **Manual Override**: Manual compression still works on excluded folders

### Media Library Integration
- **Status Indicators**: View compression status directly in media library
- **Compression Details**: See file sizes, savings percentages, and error messages
- **Modal Integration**: Compress images from attachment details modal
- **Real-time Updates**: Live compression status updates

## 📋 Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- TinyPNG API key (free tier available)
- cURL extension enabled
- FileBird plugin (optional, for folder exclusion feature)

## 🔧 Installation

1. **Upload Plugin**
   - Upload the plugin files to `/wp-content/plugins/image-compression-plugin/`
   - Or install via WordPress admin → Plugins → Add New

2. **Activate Plugin**
   - Activate through the 'Plugins' menu in WordPress

3. **Configure API Key**
   - Get a free API key from [TinyPNG](https://tinypng.com/developers)
   - Go to Image Compression → Settings
   - Enter your API key and test the connection

4. **Optional: Install FileBird**
   - For folder exclusion functionality, install the [FileBird plugin](https://wordpress.org/plugins/filebird/)
   - Create folders in your media library to organize images

## 🎯 Usage

### Basic Compression
- **Auto Compression**: Enable in settings to compress images on upload
- **Bulk Compression**: Go to Image Compression → Bulk Compression
- **Manual Compression**: Click "Compress" links in media library

### Scheduled Compression Setup
1. Go to **Image Compression → Scheduled Compression**
2. **Enable Scheduling**: Check "Enable Scheduled Compression"
3. **Set Interval**: Choose how often to run (hourly, daily, etc.)
4. **Configure Batch Size**: 
   - Set custom number of images per run
   - Or choose "unlimited" for processing all at once
5. **Save Settings**: Click "Save Settings"

### Folder Exclusion (FileBird Required)
1. **Install FileBird**: Make sure FileBird plugin is active
2. **Create Folders**: Organize your media library with FileBird folders
3. **Configure Exclusions**:
   - Go to Image Compression → Scheduled Compression
   - Scroll to "Folder Exclusion Settings"
   - Select folders to exclude from scheduled compression
4. **Save Settings**: Excluded folders will be skipped in future scheduled runs

### Folder Exclusion Use Cases
- **Client Assets**: Exclude folders with client-provided images
- **Archive Folders**: Keep backup/archive folders untouched
- **Original Preserves**: Maintain folders with original, uncompressed images
- **Selective Processing**: Only compress images in specific categories

## 📊 Dashboard Overview

The plugin provides comprehensive statistics and controls:

### Dashboard Cards
- **Total Images Compressed**: Count of successfully compressed images
- **Total Space Saved**: Cumulative file size reduction
- **Average Savings**: Overall compression percentage

### Compression History
- **Searchable Table**: Find specific compressed images
- **Filter Options**: Filter by status, date range, or search terms
- **Detailed Information**: View original size, compressed size, and savings

### Scheduler Status
- **Current Status**: Active/Inactive indicator
- **Next Run Time**: When the next scheduled compression will occur
- **Last Run Stats**: Results from the most recent compression run
- **Activity Logs**: Detailed log of all scheduler activities

## 🛠️ Configuration Options

### General Settings
- **API Key**: Your TinyPNG API key
- **Auto Compress**: Enable compression on image upload
- **API Testing**: Test your API key connection

### Scheduler Settings
- **Enable/Disable**: Toggle scheduled compression
- **Compression Interval**: From every minute to weekly
- **Batch Processing**: Custom batch sizes or unlimited
- **Folder Exclusions**: Select FileBird folders to exclude

## 🔍 Troubleshooting

### Common Issues
1. **API Key Errors**: Verify your TinyPNG API key is valid
2. **No Folders Showing**: Ensure FileBird plugin is installed and active
3. **Scheduling Not Working**: Check WordPress cron is functioning
4. **Large File Failures**: Increase PHP memory limit or reduce batch size

### Debug Information
- Check **Activity Logs** in Scheduled Compression page
- Review **Compression History** for error messages
- Use **Run Now** button to test scheduler manually

## 📝 Changelog

### Version 1.0.0
- Initial release with core compression features
- Bulk compression with progress tracking
- Scheduled compression with flexible intervals
- **NEW**: FileBird folder exclusion functionality
- Media library integration
- Comprehensive statistics and logging
- Modern, responsive admin interface

## 🤝 Support

For support, feature requests, or bug reports:
1. Check the troubleshooting section above
2. Review the activity logs for error messages
3. Ensure all requirements are met
4. Contact plugin support with specific error details

## 📄 License

This plugin is licensed under GPL v2 or later.

---

**Note**: The folder exclusion feature requires the FileBird plugin to be installed and active. Without FileBird, the plugin will still function normally but folder exclusion options will not be available. 